// Ensure LOCAL_MODE has a fallback
var LOCAL_MODE = typeof LOCAL_MODE !== 'undefined' ? LOCAL_MODE : false;

// Ensure default ajax-div exists
if (!document.getElementById('ajax-div')) {
    $('body').append('<div id="ajax-div"></div>');
}

// Form attribute checker
function form_check_required_attributes(form) {
    const $form = $(form);

    return {
        output_div: $form.data('output-div') || "ajax-div",
        formid: $form.attr('id') || '',
        method: $form.attr('method') || '',
        actionurl: $form.attr('action') || '',
        redirect_link: $form.data('redirect-link'),
        page_reload: $form.data('page-reload'),
        show_after_form: $form.data('show-after-form'),
        show_in_modal: $form.data('show-in-modal'),
        show_progress_bar: $form.data('show-progress-bar'),
        disable_output_div: $form.data('disable-output-div'),
        hide_on_complete: $form.data('hide-on-complete'),
        disable_form_reset: $form.data('disable-form-reset')
    };
}

// function show_output_in_modal(content = "", title = "Submitting") {
//     const id = 'ajax_output_modal';
//     if (!document.getElementById(id)) {
//         $("body").append(`
//             <div class="modal" id="${id}" style="overflow-y:scroll;overflow-x:scroll;">
//                 <div class="modal-dialog">
//                     <div class="modal-content">
//                         <div class="modal-header text-center">
//                             <h4 class="modal-title">${title}</h4>
//                         </div>
//                         <div class="modal-body">${content}</div>
//                         <div class="modal-footer">
//                             <button type="button" class="btn btn-danger close" data-dismiss="modal" data-bs-dismiss="modal">Close</button>
//                         </div>
//                     </div>
//                 </div>
//             </div>
//         `);
//     }
//     $(`#${id} .modal-title`).html(title);
//     $(`#${id} .modal-body`).html(content);
//     $(`#${id}`).modal('show', { backdrop: 'static' });
// }

function show_output_in_modal(content = "", title = "Message") {
    const id = 'ajax_output_modal';
    const modalSelector = `#${id}`;

    if (!document.getElementById(id)) {
        $("body").append(`
            <div class="modal fade" id="${id}" tabindex="-1" role="dialog">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">${title}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">${content}</div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
        `);
    } else {
        $(`${modalSelector} .modal-title`).html(title);
        $(`${modalSelector} .modal-body`).html(content);
    }

    $(modalSelector).modal('show');
}



function ajax_form_success(attr, response) {
    if (response.status === 'success' || response.status === true) {
        if (attr.disable_output_div !== "true") {
            $(`#${attr.output_div} #ajax-output`).append(response.message);
        }
        if (attr.show_after_form === "true") {
            $(`#${attr.formid}`).after(response.message);
        }
        if (attr.show_in_modal === "true") {
            show_output_in_modal(response.message, "Message");
        }
        if (attr.page_reload === "true") {
            setTimeout(() => window.location.reload(), 2000);
        } else if (attr.redirect_link) {
            setTimeout(() => window.location.href = attr.redirect_link, 2000);
        } else {
            $(`#${attr.output_div} #ajax-loader`).hide();
            if (attr.disable_form_reset !== "true") {
                $(`#${attr.formid}`)[0].reset();
            }
        }
    } else {
        $(`#${attr.output_div} #ajax-output`).append(response.message);
        $(`#${attr.output_div} #ajax-loader`).hide();
    }
}

function ajax_form_load(attr) {
    const loaderHTML = `
        <div align="center" style="width:100%">
            ${attr.show_progress_bar === "true" ? `
                <div class="progress" style="margin-bottom:-10px" id="progress-div">
                    <div class="progress-bar progress-bar-primary progress-bar-striped active myprogress" role="progressbar" style="width:0%;">
                        <span class="sr-only">0%</span>
                    </div>
                </div>` : ''
            }
            <div id="ajax-output"></div>
            <div id="ajax-loader" class="bg-warning-subtle py-2" style="display:none;">
                <div class="spinner-border text-primary" role="status"></div>
                <span>Submitting, please wait...</span>
            </div>
        </div>`;

    if (attr.disable_output_div !== "true") {
        $(`#${attr.output_div}`).html(loaderHTML);
    }
    if (attr.show_in_modal === "true") {
        show_output_in_modal(loaderHTML, 'Submitting...');
    }
    if (attr.show_after_form === "true") {
        $(`#${attr.formid}`).after(loaderHTML);
    }

    $(`#${attr.output_div} #ajax-loader`).show();
}

function ajax_form_complete(attr) {
    $(`#${attr.output_div} #ajax-loader`).hide();
    if (attr.hide_on_complete !== "false") {
       $(`#${attr.output_div}`).fadeTo(3000, 500).slideUp(500, function () {
    $(this).hide().html('');
});
    }
}

function ajax_form_error(attr, xhr, status, error) {
    if (LOCAL_MODE) {
        show_output_in_modal(xhr.responseText, `${status} - ${error}`);
    } else {
        alert(`${status} - Error: ${error}`);
    }
}

$(document).on('submit', 'form.ajax-form-submit', function (e) {
    e.preventDefault();
    const form = this;
    const attr = form_check_required_attributes(form);

    if (!attr.formid || !attr.method || !attr.actionurl) {
        alert("Missing form ID, method, or action.");
        return false;
    }

    if (attr.disable_output_div === "true" && attr.show_after_form !== "true" && attr.show_in_modal !== "true") {
        alert("All output displays are disabled: Cannot post form");
        return false;
    }

    const formData = new FormData(form);

    $.ajax({
        type: attr.method,
        url: attr.actionurl,
        async: true,
        cache: false,
        data: formData,
        dataType: 'json',
        beforeSend: function () {
            ajax_form_load(attr);
            $('.myprogress').css('width', '0');
        },
        xhr: function () {
            const xhr = new window.XMLHttpRequest();
            xhr.upload.addEventListener("progress", function (evt) {
                if (evt.lengthComputable) {
                    const percent = parseInt((evt.loaded / evt.total) * 100);
                    $('.myprogress').text(`${percent}%`).css('width', `${percent}%`);
                }
            });
            return xhr;
        },
        success: function (response) {
            ajax_form_success(attr, response);
        },
        contentType: false,
        processData: false,
        error: function (xhr, status, error) {
            ajax_form_error(attr, xhr, status, error);
        },
        complete: function () {
            ajax_form_complete(attr);
        }
    });
});
